<?php
// 📍 /pasti/test_whatsapp.php
require_once __DIR__ . '/config/db.php';
require_once __DIR__ . '/includes/whatsapp_helper.php';

date_default_timezone_set('Asia/Kuala_Lumpur');
$logFile = __DIR__ . '/logs/test_whatsapp_log.txt';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nama = $_POST['nama'] ?? 'Ujian';
    $phone = $_POST['phone'] ?? '';
    $order_id = $_POST['order_id'] ?? 'TEST' . rand(1000, 9999);
    $amount = $_POST['amount'] ?? '0.00';

    if (empty($phone)) {
        die("<p style='color:red'>⚠️ Sila isi nombor telefon penerima!</p>");
    }

    $data = [
        'nama' => $nama,
        'phone' => $phone,
        'order_id' => $order_id,
        'amount' => number_format($amount, 2),
        'tarikh' => date('d-m-Y H:i:s'),
        'link_bayaran' => 'https://kualanerus.net/pasti/payment/sample-link'
    ];

    file_put_contents($logFile, "\n[" . date('Y-m-d H:i:s') . "] 🚀 TEST START\n", FILE_APPEND);
    file_put_contents($logFile, "DATA:\n" . print_r($data, true) . "\n", FILE_APPEND);

    $result = sendWhatsAppTemplate('paid', $data);

    file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] ✅ RESULT:\n" . print_r($result, true) . "\n", FILE_APPEND);

    echo "<p><b>Hasil ujian:</b></p>";
    echo "<pre>" . print_r($result, true) . "</pre>";
    echo "<p>Semak log di: <code>/logs/test_whatsapp_log.txt</code></p>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="ms">
<head>
  <meta charset="utf-8">
  <title>Ujian WhatsApp - Wablas API</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-5 bg-light">
  <div class="container">
    <div class="card shadow p-4 mx-auto" style="max-width:500px">
      <h3 class="mb-4 text-center">🧩 Ujian Hantar WhatsApp</h3>
      <form method="POST">
        <div class="mb-3">
          <label class="form-label">Nama Penerima</label>
          <input type="text" name="nama" class="form-control" placeholder="Contoh: Ahmad" required>
        </div>

        <div class="mb-3">
          <label class="form-label">No. Telefon (tanpa +)</label>
          <input type="text" name="phone" class="form-control" placeholder="Contoh: 60123456789" required>
        </div>

        <div class="mb-3">
          <label class="form-label">Jumlah (RM)</label>
          <input type="text" name="amount" class="form-control" placeholder="Contoh: 20.00" required>
        </div>

        <div class="text-center">
          <button type="submit" class="btn btn-success px-4 py-2">🚀 Hantar Ujian WhatsApp</button>
        </div>
      </form>
    </div>
  </div>
</body>
</html>
