<?php
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/toyyibpay_helper.php';
require_once __DIR__ . '/../config/app.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') exit('Invalid access');

$buyer_name = trim($_POST['buyer_name'] ?? '');
$buyer_phone = trim($_POST['buyer_phone'] ?? '');
$pakej = $_POST['pakej'] ?? '';

if (!$buyer_name || !$buyer_phone || !$pakej) {
  exit('Sila isi semua maklumat.');
}

$harga = 0;
switch ($pakej) {
  case '5km': $harga = 55; break;
  case '10km': $harga = 79; break;
  case 'group': $harga = 40; break;
  default: exit('Pakej tidak sah');
}

$order_id = 'RUN-' . strtoupper(bin2hex(random_bytes(4)));

$stmt = $pdo->prepare("INSERT INTO sales (order_id,buyer_name,buyer_phone,amount,payment_status) VALUES (:id,:n,:p,:a,'PENDING')");
$stmt->execute([
  ':id'=>$order_id,
  ':n'=>$buyer_name,
  ':p'=>$buyer_phone,
  ':a'=>$harga
]);

$set = $pdo->query("SELECT * FROM payment_settings WHERE gateway_name='toyyibpay' LIMIT 1")->fetch();
$api_key = $set['api_key'] ?? '';
$category = $set['category_code'] ?? '';
$env = $set['environment'] ?? 'production';

$returnUrl = BASE_URL . '/payment/callback.php';
$bill = createToyyibBill($api_key, $category, $order_id, $buyer_name, $harga, $returnUrl, $env);

if (!empty($bill['bill_url'])) {
  header('Location: ' . $bill['bill_url']);
  exit;
} else {
  echo "Gagal cipta bil.";
}
