<?php
// ✅ /pasti/payment/return.php — Ultimate Edition 2025-11-04
define('TOYYIB_INTERNAL', true);

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/toyyibpay_helper.php';
require_once __DIR__ . '/callback_toyyib.php';

date_default_timezone_set('Asia/Kuala_Lumpur');

$status_id = $_GET['status_id'] ?? '';
$billcode  = $_GET['billcode'] ?? '';
$order_id  = $_GET['order_id'] ?? '';
$msg       = $_GET['msg'] ?? '';
$trx       = $_GET['transaction_id'] ?? '';

$logFile = __DIR__ . '/return_log.txt';
file_put_contents($logFile, "[".date('Y-m-d H:i:s')."] RETURN PARAMS: ".print_r($_GET,true)."\n", FILE_APPEND);

// --- ambil config toyyibpay ---
$stmt = $pdo->query("SELECT api_key, environment FROM payment_settings WHERE gateway_name='toyyibpay' LIMIT 1");
$cfg  = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$cfg) die("<div class='alert alert-danger'>Ralat: Tetapan ToyyibPay tidak dijumpai.</div>");

$api_key = $cfg['api_key'];
$env     = $cfg['environment'];

// --- semak bil ---
$verify = verifyToyyibBill($api_key, $billcode, $env);

$status_txt   = "Menunggu pengesahan pembayaran...";
$status_class = "pending";
$name   = "-";
$amount = "-";
$date   = "-";
$trxid  = $trx ?: "-";
$retry_link = null;

// ✅ pastikan verify berbentuk array
if (is_array($verify) && isset($verify[0])) {
    $r = $verify[0];
    $name   = $r['billTo'] ?? "-";
    $amount = "RM" . number_format($r['billpaymentAmount'] ?? 0, 2);
    $date   = $r['billPaymentDate'] ?? "-";
    $trxid  = $r['billpaymentInvoiceNo'] ?? $trxid;
    $billStatus = $r['billpaymentStatus'] ?? '0';

    if ($billStatus == '1') {
        $status_txt   = "✅ Pembayaran berjaya!";
        $status_class = "paid";
    } elseif ($billStatus == '2') {
        $status_txt   = "⏳ Menunggu pengesahan";
        $status_class = "pending";
    } else {
        $status_txt   = "❌ Pembayaran tidak berjaya";
        $status_class = "failed";
        $retry_link = "https://toyyibpay.com/" . $billcode;
    }

    // update DB bila berjaya
    if ($billStatus == '1') {
        try {
            $stmt = $pdo->prepare("
                UPDATE sales 
                SET payment_status = 'PAID',
                    payment_date = NOW(),
                    bill_code = :billcode,
                    meta = JSON_MERGE_PATCH(IFNULL(meta, JSON_OBJECT()), :meta)
                WHERE order_id = :order_id
            ");
            $meta = json_encode([
                'source'         => 'return.php',
                'status'         => 'PAID',
                'transaction_id' => $trxid,
                'billcode'       => $billcode,
                'verified_at'    => date('Y-m-d H:i:s')
            ]);
            $stmt->execute([
                ':billcode' => $billcode,
                ':meta'     => $meta,
                ':order_id' => $order_id
            ]);
            file_put_contents($logFile, "[".date('Y-m-d H:i:s')."] ✅ $order_id dikemas kini ke PAID\n", FILE_APPEND);
        } catch (Exception $e) {
            file_put_contents($logFile, "[".date('Y-m-d H:i:s')."] ❌ DB Error: ".$e->getMessage()."\n", FILE_APPEND);
        }
    } else {
        file_put_contents($logFile, "[".date('Y-m-d H:i:s')."] ⚠️ Payment failed/pending for $order_id (Status: $billStatus)\n", FILE_APPEND);
    }
} else {
    $status_txt   = "❌ Gagal menyemak status bil";
    $status_class = "failed";
    $retry_link = "https://toyyibpay.com/" . $billcode;
    file_put_contents($logFile, "[".date('Y-m-d H:i:s')."] ⚠️ verifyToyyibBill tiada data sah untuk billcode=$billcode\n", FILE_APPEND);
}
?>

<!DOCTYPE html>
<html lang="ms">
<head>
<meta charset="utf-8">
<title>Semakan Pembayaran | PASTI Kuala Nerus</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body {
  background: linear-gradient(180deg, #f8fafc, #eef3f8);
  font-family: "Poppins", sans-serif;
}
.card {
  max-width: 720px;
  margin: 60px auto;
  border-radius: 20px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}
.status { font-size: 1.4rem; font-weight: 600; }
.pending { color: #ff9800; }
.paid { color: #2e8b57; }
.failed { color: #c62828; }
.spinner {
  width: 60px; height: 60px;
  border: 6px solid #ddd; border-top: 6px solid #1b5e20;
  border-radius: 50%; margin: 15px auto;
  animation: spin 1.2s linear infinite;
}
@keyframes spin { 0% { transform: rotate(0deg); } 100% { transform: rotate(360deg); } }
.table th { background: #f4f6f9; }
.btn-success { background: #2e8b57; border: none; }
.btn-success:hover { background: #256f48; }
.btn-retry { background: #d32f2f; color: white; border: none; }
.btn-retry:hover { background: #b71c1c; }
.fade-popup, .refresh-popup {
  position: fixed;
  bottom: 20px;
  left: 50%;
  transform: translateX(-50%);
  background: rgba(46, 139, 87, 0.9);
  color: white;
  padding: 12px 24px;
  border-radius: 50px;
  font-size: 0.95rem;
  animation: fadeInOut 4s ease-in-out;
}
.refresh-popup {
  background: rgba(255, 152, 0, 0.9);
}
@keyframes fadeInOut {
  0% { opacity: 0; bottom: 0; }
  20% { opacity: 1; bottom: 20px; }
  80% { opacity: 1; }
  100% { opacity: 0; bottom: 0; }
}
</style>
</head>
<body>

<div class="card p-4 text-center">
  <center><img src="../assets/logo_pasti.png" height="90" alt="PASTI"></center>
  <h4 class="mt-3">Pusat Asuhan Tunas Islam (PASTI)</h4>
  <small class="text-muted">Kuala Nerus, Terengganu</small>
  <hr>

  <div id="status-section">
    <?php if ($status_class == "pending"): ?>
      <div class="spinner"></div>
    <?php elseif ($status_class == "paid"): ?>
      <center><img src="../assets/right.png" height="70" alt="Success"></center>
    <?php else: ?>
      <center><img src="../assets/failed.png" height="70" alt="Failed"></center>
    <?php endif; ?>

    <h5 class="status <?= $status_class ?>"><?= $status_txt ?></h5>
    <p class="text-muted">
      <?= ($status_class == "pending") 
          ? "Sistem akan menyemak semula status pembayaran dalam masa 15 saat...<br>Anda akan dibawa ke laman utama selepas 30 saat." 
          : (($status_class == "paid") 
              ? "Terima kasih! Transaksi anda telah disahkan oleh ToyyibPay." 
              : "Transaksi anda tidak berjaya diproses. Anda boleh cuba semula pembayaran.") ?>
    </p>
  </div>

  <table class="table table-bordered bg-white text-start mt-3">
    <tr><th>Nama Pelanggan</th><td><?= htmlspecialchars($name) ?></td></tr>
    <tr><th>Jumlah Bayaran</th><td><?= htmlspecialchars($amount) ?></td></tr>
    <tr><th>Tarikh Bayaran</th><td><?= htmlspecialchars($date) ?></td></tr>
    <tr><th>Status</th><td class="<?= $status_class ?>"><?= strtoupper($status_txt) ?></td></tr>
    <tr><th>Kod Bil</th><td><?= htmlspecialchars($billcode) ?></td></tr>
    <tr><th>ID Transaksi</th><td><?= htmlspecialchars($trxid) ?></td></tr>
  </table>

  <div class="mt-4">
    <?php if ($status_class == "paid"): ?>
      <a href="../payment/receipt_pdf.php?bill=<?= urlencode($billcode) ?>" class="btn btn-success btn-lg">
        📄 Muat Turun Resit (PDF)
      </a>
    <?php elseif ($status_class == "failed" && $retry_link): ?>
      <a href="<?= htmlspecialchars($retry_link) ?>" class="btn btn-retry btn-lg">
        🔁 Cuba Bayar Semula
      </a>
    <?php endif; ?>
  </div>

  <div class="mt-3">
    <a href="/pasti/" class="btn btn-outline-secondary btn-sm">← Kembali ke Laman Utama</a>
  </div>
</div>

<audio id="notifSound" src="https://assets.mixkit.co/sfx/preview/mixkit-confirmation-positive-tone-2863.mp3" preload="auto"></audio>

<div id="popup" class="fade-popup" style="display:none;">🌿 Terima kasih, anda akan dibawa ke laman utama...</div>
<div id="refreshPopup" class="refresh-popup" style="display:none;">🔄 Menyemak status pembayaran...</div>

<script>
let refreshed = false;
if ("<?= $status_class ?>" === "pending") {
  // Paparan semak status selepas 12s
  setTimeout(() => {
    document.getElementById("refreshPopup").style.display = "block";
  }, 12000);

  // Auto refresh sekali selepas 15s
  setTimeout(() => {
    if (!refreshed) {
      refreshed = true;
      location.reload();
    }
  }, 15000);

  // Popup + Redirect ke home selepas 30s
  setTimeout(() => {
    document.getElementById("popup").style.display = "block";
    setTimeout(() => { window.location.href = "/pasti/"; }, 3500);
  }, 30000);
}

// Main bunyi jika berjaya
if ("<?= $status_class ?>" === "paid") {
  document.getElementById("notifSound").play();
}
</script>
</body>
</html>
