<?php
// payment/receipt_pdf.php (versi watermark + QR aktif)

ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

date_default_timezone_set('Asia/Kuala_Lumpur');

$bill = $_GET['bill'] ?? '';
$order_id = $_GET['order_id'] ?? '';

if (!$bill && !$order_id) {
    die('<h3 style="color:red;text-align:center;">❌ Parameter tidak sah. Sila gunakan ?bill= atau ?order_id=</h3>');
}

// Ambil data dari DB
if ($bill) {
    $stmt = $pdo->prepare("SELECT * FROM sales WHERE bill_code = :bill LIMIT 1");
    $stmt->execute([':bill' => $bill]);
} else {
    $stmt = $pdo->prepare("SELECT * FROM sales WHERE order_id = :order_id LIMIT 1");
    $stmt->execute([':order_id' => $order_id]);
}
$sale = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$sale) {
    die("<h3 style='color:red;text-align:center;'>❌ Resit tidak dijumpai dalam sistem.</h3>");
}

// Sediakan data
$buyer_name = htmlspecialchars($sale['buyer_name'] ?? '');
$amount = isset($sale['amount']) ? number_format($sale['amount'], 2) : '0.00';
$status = strtoupper($sale['payment_status'] ?? '');
$payment_date = $sale['payment_date'] ? date('d-m-Y h:i A', strtotime($sale['payment_date'])) : '-';
$bill_code = htmlspecialchars($sale['bill_code'] ?? '');
$order_id = htmlspecialchars($sale['order_id'] ?? '');
$trx_id = '-';

if (!empty($sale['meta'])) {
    $metaArr = json_decode($sale['meta'], true);
    if (is_array($metaArr)) {
        $trx_id = $metaArr['billpaymentInvoiceNo'] ?? $metaArr['transaction_id'] ?? '-';
    }
}

// ✅ Link untuk QR
$qr_url = "https://kualanerus.net/pasti/payment/receipt_pdf.php?order_id=" . urlencode($order_id);

// ✅ QR Generator API (berfungsi)
$qr_img = "https://api.qrserver.com/v1/create-qr-code/?size=160x160&data=" . rawurlencode($qr_url);

// ✅ Watermark text jika status = PAID
$watermark_html = '';
if ($status === 'PAID') {
    $watermark_html = "
    <div style='
        position: fixed;
        top: 45%;
        left: 20%;
        opacity: 0.1;
        font-size: 120px;
        color: green;
        transform: rotate(-30deg);
        font-weight: 900;
        text-transform: uppercase;
        z-index: -1;
    '>SAH DIBAYAR</div>";
}

// ✅ HTML utama PDF
$html = "
<style>
body { font-family: DejaVu Sans, sans-serif; color:#333; }
.container { width:720px; margin: 20px auto; padding:25px; border:1px solid #e0e0e0; border-radius:10px; position: relative; }
.header { text-align:center; border-bottom:3px solid #198754; padding-bottom:10px; margin-bottom:15px; }
.header img { height:80px; }
.h1 { font-size:22px; color:#198754; font-weight:700; margin-top:6px; }
.sub { color:#666; font-size:12px; }
.table { width:100%; border-collapse: collapse; margin-top:18px; }
.table td { padding:10px; border:1px solid #e9e9e9; vertical-align:top; }
.label { width:35%; background:#f7fbf7; font-weight:600; color:#333; }
.value { width:65%; }
.footer { text-align:center; margin-top:18px; font-size:11px; color:#777; }
.qr { text-align:center; margin-top:12px; }
.qr img { height:110px; }
</style>

<div class='container'>
    {$watermark_html}

    <div class='header'>
        <img src='https://kualanerus.net/pasti/assets/logo_pasti.png' alt='logo'>
        <div class='h1'>Resit Rasmi Pembayaran</div>
        <div class='sub'>Pusat Asuhan Tunas Islam (PASTI) — Pekan Batu Enam, Kuala Nerus</div>
    </div>

    <table class='table'>
        <tr><td class='label'>Nama Pelanggan</td><td class='value'>{$buyer_name}</td></tr>
        <tr><td class='label'>Order ID</td><td class='value'>{$order_id}</td></tr>
        <tr><td class='label'>Jumlah Bayaran</td><td class='value'>RM {$amount}</td></tr>
        <tr><td class='label'>Status</td><td class='value'>" . 
            ($status === 'PAID' ? "<span style='color:#2e7d32;font-weight:700;'>PAID</span>" 
            : "<span style='color:#f57c00;font-weight:700;'>$status</span>") . 
        "</td></tr>
        <tr><td class='label'>Tarikh Bayaran</td><td class='value'>{$payment_date}</td></tr>
        <tr><td class='label'>Kod Bil</td><td class='value'>{$bill_code}</td></tr>
        <tr><td class='label'>ID Transaksi</td><td class='value'>{$trx_id}</td></tr>
    </table>

    <div class='qr'>
        <img src='{$qr_img}' alt='QR Code'>
        <div style='font-size:11px;color:#666;margin-top:6px;'>Imbas untuk semak resit ini secara dalam talian</div>
        <div style='font-size:10px;color:#999;margin-top:2px;'>{$qr_url}</div>
    </div>

    <div class='footer'>
        <div>Dihasilkan secara automatik oleh Sistem PASTI Kuala Nerus</div>
        <div style='font-size:11px;margin-top:4px;'><i>Tarikh cetakan: " . date('d-m-Y h:i A') . "</i></div>
    </div>
</div>
";

// ✅ DOMPDF Setup
$options = new Options();
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("Resit_{$order_id}.pdf", ["Attachment" => false]);
exit;
