<?php
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../config/csrf.php';
require_once __DIR__ . '/../includes/toyyibpay_helper.php';
require_once __DIR__ . '/../includes/whatsapp_helper.php'; // ✅ tambah

if ($_SERVER['REQUEST_METHOD'] !== 'POST') { 
    http_response_code(405); 
    exit; 
}

$buyer_name = trim($_POST['buyer_name'] ?? '');
$buyer_phone = trim($_POST['buyer_phone'] ?? '');
$amount = floatval($_POST['amount'] ?? 0.00);

if (!$buyer_name || !$buyer_phone || $amount <= 0) {
    http_response_code(400);
    echo "Invalid input";
    exit;
}

// Jana order ID unik
$order_id = 'ORD-' . strtoupper(bin2hex(random_bytes(5)));

// Simpan ke DB
$stmt = $pdo->prepare("
    INSERT INTO sales (order_id, buyer_name, buyer_phone, amount, payment_status, created_at) 
    VALUES (:order_id, :buyer_name, :buyer_phone, :amount, 'PENDING', NOW())
");
$stmt->execute([
  ':order_id' => $order_id,
  ':buyer_name' => $buyer_name,
  ':buyer_phone' => $buyer_phone,
  ':amount' => $amount
]);

// Ambil config ToyyibPay
$s = $pdo->prepare("SELECT * FROM payment_settings WHERE gateway_name='toyyibpay' LIMIT 1");
$s->execute();
$set = $s->fetch();

$env = $set['environment'] ?? 'production';

// URL callback (ToyyibPay akan POST balik ke sini)
$return_url = BASE_URL . '/payment/return.php';

// Cipta bill ToyyibPay
$resp = createToyyibBill(
    $set['api_key'], 
    $set['category_code'], 
    $order_id, 
    $buyer_name, 
    $amount, 
    $return_url, 
    $env
);

// Jika berjaya cipta bill
if (!empty($resp['bill_url']) && !empty($resp['bill_code'])) {
    // Simpan bill_code ke DB
    $pdo->prepare("UPDATE sales SET bill_code = :bill WHERE order_id = :oid")
        ->execute([':bill' => $resp['bill_code'], ':oid' => $order_id]);

    // Hantar mesej WhatsApp (jika aktif)
    $link_bayaran = $resp['bill_url'];

    sendWhatsAppTemplate('order', [
        'nama' => $buyer_name,
        'order_id' => $order_id,
        'amount' => number_format($amount, 2),
        'phone' => $buyer_phone,
        'link_bayaran' => $link_bayaran
    ]);

    // Redirect ke ToyyibPay
    header("Location: " . $resp['bill_url']);
    exit;
} 
else {
    echo "Gagal cipta bill";
}
