<?php
// payment/check_status.php

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/toyyibpay_helper.php';

$order_id = $_GET['order_id'] ?? $_POST['order_id'] ?? null;
$manual_check = isset($_POST['manual_check']);

if ($order_id && $manual_check) {
    // Manual check with ToyyibPay API
    try {
        // Get order and settings
        $stmt = $pdo->prepare("SELECT * FROM sales WHERE order_id = :order_id");
        $stmt->execute([':order_id' => $order_id]);
        $order = $stmt->fetch();
        
        if (!$order || !$order['bill_code']) {
            $error = "Order tidak ditemui atau tiada bill code";
        } else {
            // Get ToyyibPay settings
            $stmt = $pdo->prepare("SELECT api_key, environment FROM payment_settings WHERE gateway_name='toyyibpay' LIMIT 1");
            $stmt->execute();
            $setting = $stmt->fetch();
            
            if ($setting) {
                // Check with ToyyibPay
                $verify = verifyToyyibBill($setting['api_key'], $order['bill_code'], $setting['environment']);
                
                if ($verify && isset($verify[0]) && $verify[0]['BillStatus'] == '1') {
                    // Update to PAID
                    $stmt = $pdo->prepare("UPDATE sales SET payment_status='PAID', payment_date=NOW() WHERE order_id = :order_id");
                    $stmt->execute([':order_id' => $order_id]);
                    $success_msg = "Status updated! Payment adalah BERJAYA.";
                } else {
                    $info_msg = "Payment masih pending atau gagal.";
                }
            }
        }
        
    } catch (Exception $e) {
        $error = "Error checking status: " . $e->getMessage();
    }
}

// Get current order status
if ($order_id) {
    try {
        $stmt = $pdo->prepare("SELECT * FROM sales WHERE order_id = :order_id");
        $stmt->execute([':order_id' => $order_id]);
        $order = $stmt->fetch();
    } catch (Exception $e) {
        $error = "Database error";
    }
}
?>

<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Semak Status Payment</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 600px; margin: 50px auto; padding: 20px; }
        .container { background: #f9f9f9; padding: 30px; border-radius: 8px; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; font-weight: bold; }
        input { width: 100%; padding: 10px; border: 1px solid #ddd; border-radius: 4px; }
        button { background: #007cba; color: white; padding: 12px 30px; border: none; border-radius: 4px; cursor: pointer; margin: 5px; }
        button:hover { background: #005a87; }
        .btn-warning { background: #ffc107; color: #212529; }
        .btn-warning:hover { background: #e0a800; }
        .alert { padding: 15px; border-radius: 4px; margin: 15px 0; }
        .alert-success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .alert-info { background: #d1ecf1; color: #0c5460; border: 1px solid #bee5eb; }
        .alert-danger { background: #f8d7da; color: #721c24; border: 1px solid #f5c6cb; }
        .order-details { background: white; padding: 20px; border-radius: 5px; margin: 20px 0; }
        .detail-row { display: flex; justify-content: space-between; margin: 10px 0; padding: 5px 0; border-bottom: 1px solid #eee; }
    </style>
</head>
<body>
    <div class="container">
        <h2>🔍 Semak Status Payment</h2>
        
        <?php if (isset($success_msg)): ?>
            <div class="alert alert-success"><?php echo $success_msg; ?></div>
        <?php endif; ?>
        
        <?php if (isset($info_msg)): ?>
            <div class="alert alert-info"><?php echo $info_msg; ?></div>
        <?php endif; ?>
        
        <?php if (isset($error)): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <form method="GET" action="">
            <div class="form-group">
                <label for="order_id">Order ID:</label>
                <input type="text" id="order_id" name="order_id" value="<?php echo htmlspecialchars($order_id ?? ''); ?>" placeholder="Contoh: ORDER-20241031123456-1234">
            </div>
            <button type="submit">📋 Cari Order</button>
        </form>
        
        <?php if ($order): ?>
            <div class="order-details">
                <h3>📋 Butiran Order</h3>
                
                <div class="detail-row">
                    <span><strong>Order ID:</strong></span>
                    <span><?php echo htmlspecialchars($order['order_id']); ?></span>
                </div>
                
                <div class="detail-row">
                    <span><strong>Produk:</strong></span>
                    <span><?php echo htmlspecialchars($order['product_name']); ?></span>
                </div>
                
                <div class="detail-row">
                    <span><strong>Jumlah:</strong></span>
                    <span>RM <?php echo number_format($order['amount'], 2); ?></span>
                </div>
                
                <div class="detail-row">
                    <span><strong>Pelanggan:</strong></span>
                    <span><?php echo htmlspecialchars($order['customer_name']); ?></span>
                </div>
                
                <div class="detail-row">
                    <span><strong>Status Payment:</strong></span>
                    <span style="color: <?php echo $order['payment_status'] == 'PAID' ? '#28a745' : '#ffc107'; ?>;">
                        <strong><?php echo htmlspecialchars($order['payment_status']); ?></strong>
                    </span>
                </div>
                
                <?php if ($order['payment_date']): ?>
                <div class="detail-row">
                    <span><strong>Tarikh Bayar:</strong></span>
                    <span><?php echo date('d/m/Y H:i:s', strtotime($order['payment_date'])); ?></span>
                </div>
                <?php endif; ?>
                
                <div class="detail-row">
                    <span><strong>Tarikh Order:</strong></span>
                    <span><?php echo date('d/m/Y H:i:s', strtotime($order['created_at'])); ?></span>
                </div>
                
                <?php if ($order['bill_code']): ?>
                <div class="detail-row">
                    <span><strong>Bill Code:</strong></span>
                    <span><?php echo htmlspecialchars($order['bill_code']); ?></span>
                </div>
                <?php endif; ?>
            </div>
            
            <?php if ($order['payment_status'] !== 'PAID'): ?>
                <form method="POST" action="">
                    <input type="hidden" name="order_id" value="<?php echo htmlspecialchars($order['order_id']); ?>">
                    <input type="hidden" name="manual_check" value="1">
                    <button type="submit" class="btn-warning">🔄 Semak Dengan ToyyibPay API</button>
                </form>
                <p><small>Klik butang di atas untuk semak status terkini dengan ToyyibPay server.</small></p>
            <?php endif; ?>
            
        <?php elseif ($order_id): ?>
            <div class="alert alert-danger">
                Order ID "<?php echo htmlspecialchars($order_id); ?>" tidak ditemui.
            </div>
        <?php endif; ?>
        
        <div style="margin-top: 30px;">
            <a href="create_bill.php" style="display: inline-block; padding: 12px 30px; background: #007cba; color: white; text-decoration: none; border-radius: 5px;">🛒 Order Baru</a>
        </div>
    </div>
</body>
</html>