<?php
// ✅ /pasti/payment/callback_toyyib.php — Versi stabil (2025-11-04)

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/toyyibpay_helper.php';
require_once __DIR__ . '/../includes/whatsapp_helper.php';

date_default_timezone_set('Asia/Kuala_Lumpur');
$logFile = __DIR__ . '/callback_toyyib_log.txt';
$isInternalCall = defined('TOYYIB_INTERNAL'); // jika ditakrif dari return.php

file_put_contents($logFile, "\n==============================\n[" . date('Y-m-d H:i:s') . "] CALLBACK TOYYIB START\n", FILE_APPEND);

$data = ($_SERVER['REQUEST_METHOD'] === 'POST') ? $_POST : $_GET;
if (empty($data)) {
    file_put_contents($logFile, "❌ Tiada data POST/GET diterima.\n", FILE_APPEND);
    if (!$isInternalCall) exit("No data received");
}

file_put_contents($logFile, "RAW DATA:\n" . print_r($data, true) . "\n", FILE_APPEND);

$bill_code = $data['billCode'] ?? $data['billcode'] ?? null;
$order_id  = $data['billExternalReferenceNo'] ?? $data['order_id'] ?? null;
$trx_id    = $data['billpaymentInvoiceNo'] ?? $data['transaction_id'] ?? null;
$status    = $data['billpaymentStatus'] ?? $data['status_id'] ?? null;
$amount    = $data['billpaymentAmount'] ?? null;

if (!$bill_code || !$order_id) {
    file_put_contents($logFile, "❌ Missing BillCode / OrderID\n", FILE_APPEND);
    if (!$isInternalCall) exit("Missing BillCode or OrderID");
}

// ambil config
$stmt = $pdo->prepare("SELECT api_key, environment FROM payment_settings WHERE gateway_name='toyyibpay' LIMIT 1");
$stmt->execute();
$setting = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$setting) {
    file_put_contents($logFile, "❌ Tiada config ToyyibPay.\n", FILE_APPEND);
    if (!$isInternalCall) exit("No config found");
}

$api_key = $setting['api_key'];
$env = $setting['environment'] ?? 'production';

// semak status
if (strpos($bill_code, 'SIMTEST') === 0) {
    $verifyData = [
        'billpaymentStatus' => $status,
        'billpaymentAmount' => $amount,
        'billpaymentInvoiceNo' => $trx_id,
    ];
    file_put_contents($logFile, "🚧 Mode simulasi (SIMTEST): bypass verify API\n", FILE_APPEND);
} else {
    $verify = verifyToyyibBill($api_key, $bill_code, $env);
    file_put_contents($logFile, "🔍 VERIFY RESPONSE:\n" . print_r($verify, true) . "\n", FILE_APPEND);
    if (!is_array($verify) || empty($verify[0])) {
        file_put_contents($logFile, "❌ Verify API gagal.\n", FILE_APPEND);
        if (!$isInternalCall) exit("Invalid verify response");
    }
    $verifyData = $verify[0];
}

$billStatus = $verifyData['billpaymentStatus'] ?? $status ?? 0;
file_put_contents($logFile, "➡️ Parsed verifyData: status=$billStatus amount=$amount trx=$trx_id\n", FILE_APPEND);

try {
    // 🧩 Elak mesej berulang
    $check = $pdo->prepare("SELECT meta FROM sales WHERE order_id = :oid LIMIT 1");
    $check->execute([':oid' => $order_id]);
    $current = $check->fetch(PDO::FETCH_ASSOC);
    if ($current && isset($current['meta'])) {
        $metaData = json_decode($current['meta'], true);
        if (!empty($metaData['wasap_sent']) && $metaData['wasap_sent'] === true) {
            file_put_contents($logFile, "⚠️ WhatsApp sudah dihantar sebelum ini ($order_id), langkau...\n", FILE_APPEND);
            if (!$isInternalCall) exit("Already processed");
            return;
        }
    }

    // ✅ Status berjaya
    if ($billStatus == '1') {
        $update = $pdo->prepare("UPDATE sales SET payment_status='PAID', payment_date=NOW(), payment_amount=:amount, transaction_id=:trx, bill_code=:bill, meta=JSON_MERGE_PATCH(IFNULL(meta, JSON_OBJECT()), :meta) WHERE order_id=:oid");
        $meta = json_encode($verifyData);
        $update->execute([':amount'=>$amount, ':trx'=>$trx_id, ':bill'=>$bill_code, ':meta'=>$meta, ':oid'=>$order_id]);

        $buyer = $pdo->query("SELECT buyer_name, buyer_phone, amount FROM sales WHERE order_id='$order_id'")->fetch(PDO::FETCH_ASSOC);
        if ($buyer && function_exists('sendWhatsAppTemplate')) {
            sendWhatsAppTemplate('paid', [
                'nama'=>$buyer['buyer_name'],
                'phone'=>$buyer['buyer_phone'],
                'order_id'=>$order_id,
                'amount'=>number_format($buyer['amount'],2),
                'tarikh'=>date('d/m/Y H:i')
            ]);
            $pdo->prepare("UPDATE sales SET meta=JSON_MERGE_PATCH(IFNULL(meta, JSON_OBJECT()), '{\"wasap_sent\":true}') WHERE order_id=:oid")->execute([':oid'=>$order_id]);
            file_put_contents($logFile, "💬 WhatsApp (paid) dihantar kepada {$buyer['buyer_phone']}.\n", FILE_APPEND);
        }
    } else {
        // ❌ Gagal / Batal
        $update = $pdo->prepare("UPDATE sales SET payment_status='FAILED', payment_date=NOW(), transaction_id=:trx, bill_code=:bill, meta=JSON_MERGE_PATCH(IFNULL(meta, JSON_OBJECT()), :meta) WHERE order_id=:oid");
        $meta = json_encode($verifyData);
        $update->execute([':trx'=>$trx_id, ':bill'=>$bill_code, ':meta'=>$meta, ':oid'=>$order_id]);

        $buyer = $pdo->query("SELECT buyer_name, buyer_phone, amount, bill_code FROM sales WHERE order_id='$order_id'")->fetch(PDO::FETCH_ASSOC);
        if ($buyer && function_exists('sendWhatsAppTemplate')) {
            $link = "https://toyyibpay.com/" . ($buyer['bill_code'] ?? $bill_code);
            sendWhatsAppTemplate('failed', [
                'nama'=>$buyer['buyer_name'],
                'phone'=>$buyer['buyer_phone'],
                'order_id'=>$order_id,
                'amount'=>number_format($buyer['amount'],2),
                'tarikh'=>date('d/m/Y H:i'),
                'link_bayaran'=>$link
            ]);
            $pdo->prepare("UPDATE sales SET meta=JSON_MERGE_PATCH(IFNULL(meta, JSON_OBJECT()), '{\"wasap_sent\":true}') WHERE order_id=:oid")->execute([':oid'=>$order_id]);
            file_put_contents($logFile, "💬 WhatsApp (failed) dihantar kepada {$buyer['buyer_phone']} dengan link $link.\n", FILE_APPEND);
        }
    }

} catch (Throwable $e) {
    file_put_contents($logFile, "❌ SQL Error: ".$e->getMessage()."\n", FILE_APPEND);
    if (!$isInternalCall) exit("SQL Error");
}

file_put_contents($logFile, "✅ Callback selesai ($order_id, status=$billStatus)\n", FILE_APPEND);

if (!$isInternalCall) {
    echo "OK";
    exit;
} else {
    file_put_contents($logFile, "🧩 Dipanggil dari return.php (tiada output)\n", FILE_APPEND);
}
?>
