<?php
/**
 * 🧪 ToyyibPay Callback Simulator
 * Lokasi: /pasti/payment/callback_sim.php
 * Tujuan: Uji callback_toyyib.php secara manual tanpa buat bayaran sebenar
 */

date_default_timezone_set('Asia/Kuala_Lumpur');
$callbackUrl = "https://kualanerus.net/pasti/payment/callback_toyyib.php"; // Pastikan betul
$order_id = "SHIRT-" . strtoupper(bin2hex(random_bytes(3)));
$billCode = "TEST" . strtoupper(bin2hex(random_bytes(2)));
$trx = "TP" . date('ymdHis');

$data = [
    'billCode' => $billCode,
    'billExternalReferenceNo' => $order_id,
    'billpaymentStatus' => '1', // 1 = berjaya, 2 = gagal, 3 = belum bayar
    'billpaymentAmount' => '40.00',
    'billpaymentInvoiceNo' => $trx,
];

echo "<h2>🧪 Callback Simulator</h2>";
echo "<p>Menghantar data ujian ke <b>$callbackUrl</b>...</p>";
echo "<pre>" . print_r($data, true) . "</pre>";

// CURL untuk hantar POST tiruan
$ch = curl_init($callbackUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
$response = curl_exec($ch);
$http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error = curl_error($ch);
curl_close($ch);

echo "<h3>📡 Respons dari callback_toyyib.php</h3>";
echo "<pre>HTTP $http\n$response\n$error</pre>";

$logFile = __DIR__ . '/callback_sim_log.txt';
file_put_contents($logFile, "[".date('Y-m-d H:i:s')."] SENT DATA: ".json_encode($data)." | HTTP=$http | RESPONSE=$response | ERROR=$error\n", FILE_APPEND);

echo "<p>✅ Log disimpan di <code>$logFile</code></p>";
?>
