<?php
// =========================
// /payment/callback_debug.php
// Debug callback ToyyibPay — versi penuh (selamat & berfungsi)
// =========================

require_once __DIR__ . '/../config/db.php';

// Log file (untuk rujukan manual)
$logFile = __DIR__ . '/callback_debug_log.txt';

// Mula log
file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] CALLBACK START\n", FILE_APPEND);
echo "✅ Callback Debug Aktif<br>";

// ----------------------
// 1️⃣ Semak jenis request
// ----------------------
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    $msg = "❌ Bukan POST request — ini akses browser biasa.";
    file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] $msg\n", FILE_APPEND);
    echo "<span style='color:orange'>$msg</span>";
    exit;
}

// ----------------------
// 2️⃣ Log semua data POST
// ----------------------
file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] POST DATA:\n" . print_r($_POST, true) . "\n", FILE_APPEND);

echo "📩 Data diterima dari ToyyibPay (POST)<br>";

// Ambil data penting
$billCode = $_POST['billCode'] ?? null;
$orderId = $_POST['billExternalReferenceNo'] ?? null;
$status = $_POST['billpaymentStatus'] ?? null;

// ----------------------
// 3️⃣ Simpan ke table payment_logs
// ----------------------
try {
    // Buat table jika belum wujud
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS payment_logs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            log_time DATETIME DEFAULT CURRENT_TIMESTAMP,
            source VARCHAR(50),
            order_id VARCHAR(100),
            bill_code VARCHAR(100),
            message TEXT,
            raw_data TEXT,
            status VARCHAR(20)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ");

    $stmt = $pdo->prepare("
        INSERT INTO payment_logs (source, order_id, bill_code, message, raw_data, status)
        VALUES ('callback_debug', :order_id, :bill_code, 'POST diterima', :raw, 'ok')
    ");

    $stmt->execute([
        ':order_id' => $orderId,
        ':bill_code' => $billCode,
        ':raw' => json_encode($_POST, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE)
    ]);

    file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] ✅ Data disimpan ke DB (payment_logs)\n", FILE_APPEND);
    echo "✅ Data disimpan dalam <b>payment_logs</b><br>";
} catch (Exception $e) {
    file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] ❌ DB Error: " . $e->getMessage() . "\n", FILE_APPEND);
    echo "❌ DB Error: " . $e->getMessage() . "<br>";
}

// ----------------------
// 4️⃣ Jika status = 1 → kemas kini jadual sales
// ----------------------
if ($status == '1' && $orderId) {
    try {
        $update = $pdo->prepare("
            UPDATE sales 
            SET payment_status='PAID',
                payment_date=NOW(),
                bill_code=:bill_code,
                meta=JSON_MERGE_PATCH(IFNULL(meta, JSON_OBJECT()), :meta)
            WHERE order_id=:order_id
        ");

        $meta = json_encode($_POST, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        $update->execute([
            ':bill_code' => $billCode,
            ':meta' => $meta,
            ':order_id' => $orderId
        ]);

        if ($update->rowCount() > 0) {
            file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] ✅ SALES dikemas kini (order: $orderId)\n", FILE_APPEND);
            echo "✅ Order <b>$orderId</b> ditanda sebagai <b>PAID</b><br>";
        } else {
            file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] ⚠️ Tiada rekod SALES dikemas kini.\n", FILE_APPEND);
            echo "⚠️ Tiada rekod sales dikemas kini (mungkin order_id tak wujud)<br>";
        }
    } catch (Exception $e) {
        file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] ❌ SALES update error: " . $e->getMessage() . "\n", FILE_APPEND);
        echo "❌ SALES update error: " . $e->getMessage() . "<br>";
    }
} else {
    echo "ℹ️ Status bukan '1' atau tiada order_id.<br>";
}

// ----------------------
// 5️⃣ Tamat
// ----------------------
echo "<hr>🚀 Callback Debug Tamat.";
file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] 🚀 Callback Debug Tamat\n\n", FILE_APPEND);
