<?php
// /payment/callback.php — versi FORCE DEBUG

require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/toyyibpay_helper.php';

// 🧾 Lokasi fail log alternatif — confirm boleh tulis
$logFile = '/tmp/pasti_callback_log.txt';
if (!is_writable('/tmp')) {
    $logFile = __DIR__ . '/callback_fallback_log.txt';
}

// Fungsi untuk tulis log
function log_force($text)
{
    global $logFile;
    @file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] " . $text . "\n", FILE_APPEND);
}

// Mula log
log_force("=====================================");
log_force("CALLBACK TRIGGERED from IP: " . ($_SERVER['REMOTE_ADDR'] ?? 'unknown'));
log_force("REQUEST_METHOD: " . $_SERVER['REQUEST_METHOD']);

// --- Debug echo ---
echo "<pre style='font-family:monospace;background:#111;color:#0f0;padding:10px;'>";

// Kalau folder tak boleh tulis
if (!is_writable(__DIR__)) {
    echo "❌ Folder <b>payment/</b> tidak boleh ditulis oleh PHP!\n";
    log_force("❌ Folder not writable: " . __DIR__);
}

// Jika bukan POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo "⚠️ Bukan POST request — ini hanya paparan browser biasa.\n";
    log_force("❌ ERROR: Ditolak - Bukan POST request.");
    echo "</pre>";
    exit;
}

// Log semua POST data
log_force("RAW POST:\n" . print_r($_POST, true));
echo "📦 Diterima POST data dari ToyyibPay:\n";
print_r($_POST);

// Ambil nilai utama
$bill_code = $_POST['billCode'] ?? $_POST['BillCode'] ?? null;
$order_id  = $_POST['billExternalReferenceNo'] ?? $_POST['order_id'] ?? null;
$status    = $_POST['billpaymentStatus'] ?? $_POST['billStatus'] ?? null;

if (!$bill_code) {
    echo "\n❌ Tiada BillCode dalam data POST!";
    log_force("❌ ERROR: Missing BillCode!");
    exit;
}

echo "\n🧾 BillCode: $bill_code";
echo "\n🧾 OrderID : $order_id";
echo "\n🧾 Status  : $status\n";

log_force("🧾 BillCode: $bill_code | Order: $order_id | Status: $status");

// Ambil config dari DB
try {
    $stmt = $pdo->prepare("SELECT api_key, environment FROM payment_settings WHERE gateway_name='toyyibpay' LIMIT 1");
    $stmt->execute();
    $setting = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    echo "\n❌ DB ERROR: " . $e->getMessage();
    log_force("❌ DB ERROR: " . $e->getMessage());
    exit;
}

if (!$setting) {
    echo "\n❌ Tetapan ToyyibPay tidak dijumpai dalam DB!";
    log_force("❌ ERROR: Tiada tetapan ToyyibPay.");
    exit;
}

$api_key = $setting['api_key'];
$env = $setting['environment'] ?? 'production';
echo "\n🌍 Environment: $env\n";

// Verify status bil
$verify = verifyToyyibBill($api_key, $bill_code, $env);
log_force("VERIFY RESPONSE:\n" . print_r($verify, true));
echo "\n📬 Hasil verifyToyyibBill():\n";
print_r($verify);

// Update ke DB jika status = 1
if (is_array($verify) && !empty($verify[0]) && (($verify[0]['billpaymentStatus'] ?? '') == '1')) {
    $order_id = $verify[0]['billExternalReferenceNo'] ?? $order_id;
    $update = $pdo->prepare("
        UPDATE sales 
        SET payment_status='PAID',
            payment_date = NOW(),
            bill_code = :bill_code,
            meta = JSON_MERGE_PATCH(IFNULL(meta, JSON_OBJECT()), :meta)
        WHERE order_id = :order_id
    ");
    $meta = json_encode($verify[0]);
    $update->execute([
        ':bill_code' => $bill_code,
        ':meta' => $meta,
        ':order_id' => $order_id
    ]);

    echo "\n✅ ORDER $order_id dikemaskini sebagai PAID!\n";
    log_force("✅ ORDER $order_id marked as PAID.");
} else {
    echo "\n⚠️ Callback diterima tapi status belum PAID.\n";
    log_force("⚠️ Callback diterima tapi status belum PAID.");
}

echo "\n📁 Log disimpan di: $logFile";
echo "\n</pre>";
