<?php
// Monsoon Fun Run 2025 — Versi kemaskini dengan validasi email & butang WhatsApp
?>
<!doctype html>
<html lang="ms">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Monsoon Fun Run 2025 | Baju Rasmi PASTI Kuala Nerus</title>
  <script src="https://cdn.tailwindcss.com"></script>
  <link href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
  <style>
    .hero-bg {
      background-image: linear-gradient(to bottom, rgba(4,120,87,0.85), rgba(0,0,0,0.65)), url('assets/pasti.jpg');
      background-size: cover;
      background-position: center;
    }
    html { scroll-behavior: smooth; }
    .blink { animation: blink 1.5s infinite; }
    @keyframes blink { 50% { opacity: 0.4; } }
  </style>
</head>
<body class="bg-gray-50 text-gray-800">

<!-- 🌿 Navbar -->
<nav class="bg-green-900 text-white shadow-lg sticky top-0 z-50">
  <div class="max-w-7xl mx-auto px-6 py-3 flex justify-between items-center">
    <div class="flex items-center gap-3">
      <img src="assets/logo_pasti.png" alt="PASTI" class="h-10 w-10 rounded-full bg-white p-1">
      <a href="#" class="text-2xl font-extrabold tracking-wide">🌧️ Monsoon Fun Run</a>
    </div>
    <a href="#order" class="bg-lime-400 text-green-900 font-bold py-2 px-5 rounded-lg hover:bg-lime-500 shadow transition">Beli Baju</a>
  </div>
</nav>

<!-- 🏃‍♂️ Hero Section -->
<section class="hero-bg h-[480px] flex items-center justify-center text-white text-center">
  <div class="px-6">
    <h1 class="text-5xl md:text-6xl font-extrabold drop-shadow-lg">MONSOON FUN RUN 2025</h1>
    <p class="text-xl mt-3 mb-6 font-light tracking-wide">Jualan Baju Rasmi • PASTI Kuala Nerus • 29 November 2025</p>
    <a href="#order" class="bg-lime-400 text-green-900 font-bold py-3 px-8 rounded-xl shadow-lg hover:bg-lime-500 transition-all transform hover:scale-105">
      🛍️ Tempah Sekarang
    </a>
  </div>
</section>

<!-- 🎯 Poster Section -->
<section class="bg-white py-10">
  <div class="max-w-5xl mx-auto px-4 text-center">
    <h2 class="text-3xl font-extrabold text-green-800 mb-4">📣 Poster Rasmi Monsoon Fun Run 2025</h2>
    <p class="text-gray-600 mb-6">Acara komuniti penuh semangat bersama keluarga dan sahabat. Sertai kami di <strong>Stadium Gong Badak</strong>!</p>
    <img src="assets/pasti.jpg" alt="Poster Monsoon Fun Run" class="rounded-2xl shadow-xl border-4 border-lime-500 mx-auto max-h-[900px] mb-8">

    <!-- 📞 Butang WhatsApp -->
    <div class="flex justify-center gap-4">
      <a href="https://wa.me/60199146713?text=Salam%2C+saya+ingin+bertanya+tentang+Monsoon+Fun+Run+2025" target="_blank"
         class="bg-green-600 hover:bg-green-700 text-white font-semibold py-3 px-6 rounded-xl shadow transition flex items-center gap-2">
         💬 Hubungi Sopi (Urusetia)
      </a>
      <a href="https://wa.me/60132281950?text=Assalamualaikum%2C+saya+ingin+menyertai+Monsoon+Fun+Run+2025" target="_blank"
         class="bg-lime-500 hover:bg-lime-600 text-green-900 font-semibold py-3 px-6 rounded-xl shadow transition flex items-center gap-2">
         📱 Hubungi Fatimah (Urusetia)
      </a>
    </div>
  </div>
</section>

<!-- ⏳ Countdown -->
<section id="countdown" class="bg-gradient-to-r from-lime-500 to-green-500 py-6 text-center text-white shadow-inner">
  <div class="max-w-4xl mx-auto px-4">
    <h3 class="text-2xl md:text-3xl font-extrabold mb-2">⏳ Tempahan Dibuka Sehingga Acara Bermula!</h3>
    <div id="countdown-timer" class="text-4xl font-mono font-bold tracking-widest">
      <span id="days">00</span><span class="text-sm">H</span> :
      <span id="hours">00</span><span class="text-sm">J</span> :
      <span id="minutes">00</span><span class="text-sm">M</span> :
      <span id="seconds">00</span><span class="text-sm">S</span>
    </div>
    <p class="mt-2 text-sm italic blink">* Jangan tunggu saat akhir, stok saiz terhad! *</p>
  </div>
</section>

<!-- 🛒 Order Form -->
<section id="order" class="py-16 bg-green-50 border-t border-green-100">
  <div class="max-w-3xl mx-auto px-6">
    <div class="bg-white p-8 rounded-2xl shadow-2xl border-t-8 border-lime-500">
      <h3 class="text-3xl font-bold mb-4 text-green-800">🧾 Tempahan Baju Rasmi</h3>
      <p class="text-gray-600 mb-6">Lengkapkan maklumat di bawah untuk menempah baju rasmi <strong>Monsoon Fun Run 2025</strong>.</p>

      <form id="orderForm" action="order_process.php" method="POST" class="space-y-4">
        <div>
          <label class="block text-sm font-medium text-gray-700">Nama Penuh</label>
          <input type="text" name="buyer_name" required class="mt-1 w-full border rounded-lg p-3 focus:ring-lime-300" placeholder="Nama mengikut resit">
        </div>

        <div>
          <label class="block text-sm font-medium text-gray-700">Alamat Emel</label>
          <input type="email" name="buyer_email" required class="mt-1 w-full border rounded-lg p-3 focus:ring-lime-300" placeholder="email@gmail.com">
        </div>

        <div>
          <label class="block text-sm font-medium text-gray-700">No. Telefon (WhatsApp)</label>
          <input type="text" name="buyer_phone" required class="mt-1 w-full border rounded-lg p-3 focus:ring-lime-300" placeholder="6012xxxxxxx">
        </div>

        <div class="grid md:grid-cols-2 gap-4">
          <div>
            <label class="block text-sm font-medium text-gray-700">Kategori Baju</label>
            <select id="kategori" name="kategori" required class="mt-1 w-full border rounded-lg p-3">
              <option value="">-- Pilih Kategori --</option>
              <option value="adult">Dewasa (RM40)</option>
              <option value="muslimah">Muslimah (RM50)</option>
              <option value="pasti">Pelajar PASTI (RM5)</option>
            </select>
          </div>
          <div>
            <label class="block text-sm font-medium text-gray-700">Saiz</label>
            <select id="size" name="size" required class="mt-1 w-full border rounded-lg p-3">
              <option value="">-- Pilih Kategori Dulu --</option>
            </select>
          </div>
        </div>

        <div class="flex items-center gap-4">
          <label class="flex items-center"><input type="checkbox" id="addon" name="addon_lengan" value="1" class="mr-2">Tambah Lengan Panjang (+RM5)</label>
          <label class="ml-auto">Kuantiti: <input type="number" name="quantity" min="1" max="10" value="1" class="ml-2 w-20 border rounded-lg p-1 text-center"></label>
        </div>

        <div class="pt-3 border-t">
          <div class="text-sm text-gray-700 mb-2">Jumlah Anggaran: <span id="priceDisplay" class="font-bold text-green-800">RM0.00</span></div>
          <button type="submit" class="w-full py-3 bg-lime-500 text-green-900 font-bold rounded-xl shadow-lg hover:bg-lime-600 transition">💳 HANTAR & BAYAR</button>
        </div>
      </form>
    </div>
  </div>
</section>

<!-- 🕒 Countdown JS -->
<script>
const eventDate = new Date("Nov 29, 2025 07:30:00").getTime();
const timer = setInterval(() => {
  const now = new Date().getTime();
  const distance = eventDate - now;
  if (distance < 0) {
    document.getElementById("countdown-timer").innerHTML = "🎉 Acara Sedang Berlangsung!";
    clearInterval(timer);
    return;
  }
  const d = Math.floor(distance / (1000 * 60 * 60 * 24));
  const h = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
  const m = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
  const s = Math.floor((distance % (1000 * 60)) / 1000);
  document.getElementById("days").textContent = d.toString().padStart(2,'0');
  document.getElementById("hours").textContent = h.toString().padStart(2,'0');
  document.getElementById("minutes").textContent = m.toString().padStart(2,'0');
  document.getElementById("seconds").textContent = s.toString().padStart(2,'0');
}, 1000);

/* 🧮 Kiraan & Validasi */
const sizeMap = {
  adult: ['XS','S','M','L','XL','2XL','3XL','4XL','5XL','6XL','7XL'],
  muslimah: ['XS','S','M','L','XL','2XL','3XL','4XL','5XL','6XL'],
  pasti: ['20','22','24','26','28','30','32','34']
};
const priceMap = { adult:40, muslimah:50, pasti:5 };
const addonPrice = 5;

const kategoriEl = document.getElementById('kategori');
const sizeEl = document.getElementById('size');
const addonEl = document.getElementById('addon');
const qtyEl = document.querySelector('input[name="quantity"]');
const priceDisplay = document.getElementById('priceDisplay');
const notyf = new Notyf({ duration: 2500, position: { x: 'right', y: 'top' }});

function populateSizes(cat){
  sizeEl.innerHTML = '<option value="">-- Pilih Saiz --</option>';
  if(!sizeMap[cat]) return;
  sizeMap[cat].forEach(s => {
    const opt = document.createElement('option');
    opt.value = s;
    opt.textContent = s;
    sizeEl.appendChild(opt);
  });
}

function calculatePrice(){
  const cat = kategoriEl.value;
  const qty = parseInt(qtyEl.value) || 1;
  if(!cat) { priceDisplay.textContent = 'RM0.00'; return; }
  let total = (priceMap[cat]||0) * qty;
  if(addonEl.checked) total += addonPrice * qty;
  priceDisplay.textContent = 'RM' + total.toFixed(2);
  return total;
}

/* ✅ FIXED Email Regex */
function validateForm() {
  const name = document.querySelector('input[name="buyer_name"]').value.trim();
  const email = document.querySelector('input[name="buyer_email"]').value.trim();
  const phone = document.querySelector('input[name="buyer_phone"]').value.trim();
  const cat = kategoriEl.value;
  const size = sizeEl.value;

  const emailRegex = /^[^\s@]+@[^\s@]+\.[A-Za-z]{2,}$/;  // ✅ Lebih fleksibel
  const phoneRegex = /^601\d{7,9}$/;

  if (!name) return notyf.error('Nama penuh wajib diisi'), false;
  if (!emailRegex.test(email)) return notyf.error('Alamat emel tidak sah'), false;
  if (!phoneRegex.test(phone)) return notyf.error('No. telefon mesti bermula dengan 601 dan 9–11 digit'), false;
  if (!cat) return notyf.error('Sila pilih kategori baju'), false;
  if (!size) return notyf.error('Sila pilih saiz baju'), false;
  return true;
}

kategoriEl.addEventListener('change', e => { populateSizes(e.target.value); calculatePrice(); });
addonEl.addEventListener('change', calculatePrice);
qtyEl.addEventListener('input', calculatePrice);

document.getElementById('orderForm').addEventListener('submit', function(e){
  if (!validateForm()) { e.preventDefault(); return; }
  const total = calculatePrice();
  if(!confirm('Jumlah: RM' + total.toFixed(2) + '. Teruskan ke pembayaran?')) e.preventDefault();
});

calculatePrice();
</script>
</body>
</html>
