<?php
require_once __DIR__ . '/../config/db.php';

/**
 * Ambil konfigurasi WhatsApp (Wablas)
 */
function getWablasConfig()
{
    $pdo = $GLOBALS['pdo'] ?? null;
    $logFile = __DIR__ . '/../logs/whatsapp_log.txt';

    if (!$pdo) {
        file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] ❌ ERROR: PDO global not found.\n", FILE_APPEND);
        return false;
    }

    $cfg = $pdo->query("SELECT * FROM whatsapp_settings WHERE is_active=1 LIMIT 1")->fetch(PDO::FETCH_ASSOC);
    if (!$cfg) {
        file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] ⚠️ WhatsApp config tiada atau tidak aktif.\n", FILE_APPEND);
        return false;
    }
    return $cfg;
}

/**
 * Hantar mesej WhatsApp menggunakan Wablas API
 */
function sendWablasMessage($api_key, $sender, $phone, $message)
{
    $logFile = __DIR__ . '/../logs/whatsapp_log.txt';
    $url = "https://tegal.wablas.com/api/send-message";

    // Normalisasi nombor telefon (pastikan format 60XXXXXXXXXX)
    $phone = preg_replace('/\D/', '', $phone);
    if (substr($phone, 0, 1) === '0') $phone = '6' . $phone;
    if (substr($phone, 0, 2) === '60') {
        // betul
    } elseif (substr($phone, 0, 3) !== '601') {
        $phone = '60' . $phone;
    }

    $data = [
        'phone'    => $phone,
        'message'  => $message,
        'secret'   => false,
        'priority' => false,
    ];

    $headers = ["Authorization: $api_key"];
    file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] 🚀 SEND TO $phone\nMESSAGE:\n$message\n", FILE_APPEND);

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $err = curl_error($ch);
    curl_close($ch);

    file_put_contents(
        $logFile,
        "[" . date('Y-m-d H:i:s') . "] ✅ HTTP=$httpCode | ERR=$err\nRESPONSE:\n$response\n-----------------------------\n",
        FILE_APPEND
    );

    return [
        'status'   => ($httpCode == 200 && !$err),
        'response' => $response,
        'http'     => $httpCode,
        'error'    => $err
    ];
}

/**
 * Hantar mesej berdasarkan template
 * Placeholder tersedia:
 * {{nama}}, {{order_id}}, {{amount}}, {{tarikh}}, {{link_bayaran}}
 */

function sendWhatsAppTemplate($type, $data)
{
    $logFile = __DIR__ . '/../logs/whatsapp_log.txt';
    $cfg = getWablasConfig();
    if (!$cfg) {
        file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] ❌ Config Wablas tidak sah.\n", FILE_APPEND);
        return false;
    }

    $templateField = 'template_' . $type;
    $template = $cfg[$templateField] ?? '';
    if (!$template) {
        file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] ⚠️ Template '$type' kosong.\n", FILE_APPEND);
        return false;
    }

    // Gantikan placeholder
    $msg = str_replace(
        ['{{nama}}', '{{order_id}}', '{{amount}}', '{{tarikh}}', '{{link_bayaran}}'],
        [
            $data['nama'] ?? '',
            $data['order_id'] ?? '',
            $data['amount'] ?? '',
            $data['tarikh'] ?? '',
            $data['link_bayaran'] ?? ''
        ],
        $template
    );

    // 📢 Hantar kepada buyer + admin sekali gus
    $adminPhone = '60135063737'; // 📍 Nombor admin
    $recipients = [$data['phone'] ?? '', $adminPhone];
    $api_key = $cfg['api_key'];
    $sender = $cfg['sender'];

    $url = "https://tegal.wablas.com/api/send-message";
    $headers = ["Authorization: $api_key"];

    foreach ($recipients as $phone) {
        $phone = preg_replace('/\D/', '', $phone);
        if (!$phone) continue;
        if (substr($phone, 0, 1) === '0') $phone = '60' . substr($phone, 1);

        $dataSend = [
            'phone' => $phone,
            'message' => $msg,
            'secret' => false,
            'priority' => false,
        ];

        file_put_contents($logFile, "[" . date('Y-m-d H:i:s') . "] 🚀 SEND TO $phone\nMESSAGE:\n$msg\n\n", FILE_APPEND);

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($dataSend));
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $err = curl_error($ch);
        curl_close($ch);

        file_put_contents(
            $logFile,
            "[" . date('Y-m-d H:i:s') . "] ✅ HTTP=$httpCode | ERR=$err\nRESPONSE:\n$response\n-----------------------------\n",
            FILE_APPEND
        );
    }

    return true;
}


?>
