<?php
session_start();
if (!empty($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
  header('Location: /admin/toyyibpay/index.php');
  exit;
}
?>
<!doctype html>
<html lang="ms">
<head>
  <meta charset="utf-8">
  <title>Login Admin</title>
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="min-h-screen flex items-center justify-center bg-gray-100">
  <form action="check_login.php" method="POST" class="bg-white p-8 rounded-2xl shadow-md w-80">
    <h2 class="text-xl font-semibold mb-5 text-center">🔐 Login Admin</h2>
    <div class="mb-4">
      <label class="block text-sm mb-1">Username</label>
      <input type="text" name="username" class="w-full border rounded px-3 py-2" required>
    </div>
    <div class="mb-4">
      <label class="block text-sm mb-1">Kata Laluan</label>
      <input type="password" name="password" class="w-full border rounded px-3 py-2" required>
    </div>
    <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white py-2 rounded">Login</button>
    <?php if(isset($_GET['error'])): ?>
      <p class="text-red-500 text-sm text-center mt-3">❌ Username atau password salah</p>
    <?php endif; ?>
  </form>
</body>
</html>
