<?php
require_once __DIR__ . '/../config/db.php';
session_start();

$username = trim($_POST['username'] ?? '');
$password = trim($_POST['password'] ?? '');

if (!$username || !$password) {
  header('Location: login.php?error=1');
  exit;
}

$stmt = $pdo->prepare("SELECT * FROM admins WHERE username = :username LIMIT 1");
$stmt->execute([':username' => $username]);
$admin = $stmt->fetch();

if ($admin && password_verify($password, $admin['password_hash'])) {
  $_SESSION['admin_logged_in'] = true;
  $_SESSION['admin_username'] = $username;
  header('Location: /admin/toyyibpay/index.php');
  exit;
}

header('Location: login.php?error=1');
exit;
