<?php
require_once __DIR__ . '/../../config/db.php';
require_once __DIR__ . '/../../config/csrf.php';
require_once __DIR__ . '/../../includes/auth.php';
admin_only();
$token = generate_csrf_token();

// ✅ Simpan data
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        http_response_code(403);
        exit('CSRF token tidak sah.');
    }

    $api_key   = trim($_POST['api_key'] ?? '');
    $secret_key = trim($_POST['secret_key'] ?? '');
    $sender    = trim($_POST['sender'] ?? '');
    $is_active = isset($_POST['is_active']) && $_POST['is_active'] == '1' ? 1 : 0;

    // Template
    $template_order      = trim($_POST['template_order'] ?? '');
    $template_paid       = trim($_POST['template_paid'] ?? '');
    $template_failed     = trim($_POST['template_failed'] ?? '');
    $template_receipt    = trim($_POST['template_receipt'] ?? '');
    $template_followup   = trim($_POST['template_followup'] ?? '');
    $template_cancelled  = trim($_POST['template_cancelled'] ?? '');

    if (!$api_key || !$sender) {
        header('Location: index.php?error=1');
        exit;
    }

    $stmt = $pdo->prepare("
        INSERT INTO whatsapp_settings 
        (id, api_key, secret_key, sender, is_active, 
         template_order, template_paid, template_failed, template_receipt, 
         template_followup, template_cancelled)
        VALUES 
        (1, :api_key, :secret_key, :sender, :is_active, 
         :template_order, :template_paid, :template_failed, :template_receipt,
         :template_followup, :template_cancelled)
        ON DUPLICATE KEY UPDATE
          api_key = VALUES(api_key),
          secret_key = VALUES(secret_key),
          sender = VALUES(sender),
          is_active = VALUES(is_active),
          template_order = VALUES(template_order),
          template_paid = VALUES(template_paid),
          template_failed = VALUES(template_failed),
          template_receipt = VALUES(template_receipt),
          template_followup = VALUES(template_followup),
          template_cancelled = VALUES(template_cancelled)
    ");
    $stmt->execute([
        ':api_key' => $api_key,
        ':secret_key' => $secret_key,
        ':sender' => $sender,
        ':is_active' => $is_active,
        ':template_order' => $template_order,
        ':template_paid' => $template_paid,
        ':template_failed' => $template_failed,
        ':template_receipt' => $template_receipt,
        ':template_followup' => $template_followup,
        ':template_cancelled' => $template_cancelled
    ]);

    header('Location: index.php?saved=1');
    exit;
}

// ✅ Ambil data semasa
$set = $pdo->query("SELECT * FROM whatsapp_settings WHERE id=1 LIMIT 1")->fetch(PDO::FETCH_ASSOC);
$api_key   = $set['api_key'] ?? '';
$secret_key = $set['secret_key'] ?? '';
$sender    = $set['sender'] ?? '';
$is_active = $set['is_active'] ?? 0;
$template_order = $set['template_order'] ?? '';
$template_paid = $set['template_paid'] ?? '';
$template_failed = $set['template_failed'] ?? '';
$template_receipt = $set['template_receipt'] ?? '';
$template_followup = $set['template_followup'] ?? '';
$template_cancelled = $set['template_cancelled'] ?? '';
?>
<!doctype html>
<html lang="ms">
<head>
  <meta charset="utf-8">
  <title>Tetapan WhatsApp (Wablas)</title>
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<?php include '../layout.php'; ?>
<body class="bg-gray-100 min-h-screen p-6">
  <div class="max-w-6xl mx-auto bg-white shadow-lg rounded-2xl p-8">
    <h1 class="text-3xl font-extrabold mb-6 text-green-700 flex items-center gap-2">
      💬 Tetapan WhatsApp (Wablas)
    </h1>

    <?php if (isset($_GET['saved'])): ?>
      <div class="bg-green-100 border border-green-300 text-green-800 px-4 py-3 rounded mb-4">
        ✅ Tetapan berjaya disimpan.
      </div>
    <?php elseif (isset($_GET['error'])): ?>
      <div class="bg-red-100 border border-red-300 text-red-800 px-4 py-3 rounded mb-4">
        ❌ Sila isi API Key dan Sender.
      </div>
    <?php endif; ?>

    <form method="POST" class="space-y-8">
      <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($token) ?>">

      <!-- 🔧 Maklumat Integrasi -->
      <section class="space-y-4">
        <h2 class="text-xl font-semibold text-gray-700 border-b pb-2">🔧 Maklumat Integrasi</h2>

        <div class="grid md:grid-cols-2 gap-5">
          <div>
            <label class="block font-medium mb-1">🔑 API Key (Token Wablas)</label>
            <input name="api_key" class="border border-gray-300 rounded-lg w-full px-3 py-2 focus:ring focus:ring-green-200" value="<?= htmlspecialchars($api_key) ?>">
          </div>
          <div>
            <label class="block font-medium mb-1">🔒 Secret Key (Opsyenal)</label>
            <input name="secret_key" class="border border-gray-300 rounded-lg w-full px-3 py-2 focus:ring focus:ring-green-200" value="<?= htmlspecialchars($secret_key) ?>">
          </div>
        </div>

        <div>
          <label class="block font-medium mb-1">📱 Sender / Device</label>
          <input name="sender" class="border border-gray-300 rounded-lg w-full px-3 py-2 focus:ring focus:ring-green-200" value="<?= htmlspecialchars($sender) ?>">
          <p class="text-sm text-gray-500 mt-1">Contoh: nombor WhatsApp atau ID device dari Dashboard Wablas.</p>
        </div>

        <div class="flex items-center gap-3">
          <label class="font-medium">🚀 Aktifkan Integrasi?</label>
          <select name="is_active" class="border rounded-lg px-3 py-2 focus:ring focus:ring-green-200">
            <option value="1" <?= $is_active ? 'selected' : '' ?>>Ya</option>
            <option value="0" <?= !$is_active ? 'selected' : '' ?>>Tidak</option>
          </select>
        </div>
      </section>

      <!-- 📜 Template Mesej -->
      <section class="space-y-8">
        <h2 class="text-xl font-semibold text-gray-700 border-b pb-2">📜 Template Mesej WhatsApp</h2>

        <?php 
        $templates = [
          ['name'=>'template_order','title'=>'📦 Tempahan Baru','color'=>'blue','placeholders'=>'{{nama}}, {{order_id}}, {{link_bayaran}}, {{amount}}','value'=>$template_order],
          ['name'=>'template_paid','title'=>'💰 Pembayaran Berjaya','color'=>'green','placeholders'=>'{{nama}}, {{order_id}}, {{amount}}, {{tarikh}}','value'=>$template_paid],
          ['name'=>'template_failed','title'=>'❌ Pembayaran Gagal / Dibatalkan','color'=>'red','placeholders'=>'{{nama}}, {{order_id}}, {{amount}}','value'=>$template_failed],
          ['name'=>'template_receipt','title'=>'📄 Pautan Resit Rasmi','color'=>'purple','placeholders'=>'{{nama}}, {{order_id}}, {{link_bayaran}}','value'=>$template_receipt],
          ['name'=>'template_followup','title'=>'⏰ Peringatan Belum Bayar','color'=>'yellow','placeholders'=>'{{nama}}, {{order_id}}, {{link_bayaran}}, {{amount}}','value'=>$template_followup],
          ['name'=>'template_cancelled','title'=>'🚫 Tempahan Dibatalkan','color'=>'gray','placeholders'=>'{{nama}}, {{order_id}}','value'=>$template_cancelled],
        ];
        ?>

        <?php foreach ($templates as $t): ?>
        <div class="bg-<?= $t['color'] ?>-50 border-l-4 border-<?= $t['color'] ?>-500 rounded-lg p-5">
          <h3 class="text-lg font-semibold text-<?= $t['color'] ?>-700 flex items-center justify-between">
            <span><?= $t['title'] ?></span>
            <button type="button" onclick="testSend('<?= $t['name'] ?>')" 
              class="text-sm bg-<?= $t['color'] ?>-600 hover:bg-<?= $t['color'] ?>-700 text-white px-3 py-1 rounded transition">
              💬 Uji Hantar
            </button>
          </h3>

          <div class="grid md:grid-cols-2 gap-4 mt-3">
            <div>
              <textarea id="<?= $t['name'] ?>" name="<?= $t['name'] ?>" rows="4"
                class="border border-<?= $t['color'] ?>-200 rounded-lg w-full px-3 py-2 focus:ring focus:ring-<?= $t['color'] ?>-300"
                oninput="updatePreview('<?= $t['name'] ?>')"><?= htmlspecialchars($t['value']) ?></textarea>
              <p class="text-sm text-<?= $t['color'] ?>-700 mt-1 italic">Placeholder: <?= $t['placeholders'] ?></p>
            </div>
            <div class="bg-white border border-<?= $t['color'] ?>-200 rounded-lg p-3">
              <p class="text-xs text-gray-400 mb-2">Pratonton Mesej:</p>
              <div id="preview_<?= $t['name'] ?>" class="bg-green-100 text-gray-800 p-3 rounded-xl shadow-inner max-w-xs">
                <?= nl2br(htmlspecialchars($t['value'])) ?>
              </div>
            </div>
          </div>
        </div>
        <?php endforeach; ?>
      </section>

      <div class="pt-6 flex gap-4">
        <button class="bg-green-600 hover:bg-green-700 text-white px-6 py-2.5 rounded-lg shadow transition-all duration-200">
          💾 Simpan Tetapan
        </button>
        <a href="../index.php" class="px-6 py-2.5 border border-gray-300 rounded-lg bg-gray-50 hover:bg-gray-100 transition-all duration-200">
          ← Kembali
        </a>
      </div>
    </form>
  </div>

  <script>
    function updatePreview(name) {
      const textarea = document.getElementById(name);
      const preview = document.getElementById("preview_" + name);
      preview.innerHTML = textarea.value.replace(/\n/g, "<br>");
    }

    function testSend(templateName) {
      const content = document.getElementById(templateName).value;
      alert("🔍 Ujian mesej template: " + templateName + "\\n\\n" + content);
    }
  </script>
</body>
</html>
<?php include '../layout_bottom.php'; ?>
