<?php
require_once __DIR__ . '/../../config/db.php';
require_once __DIR__ . '/../../config/csrf.php';
require_once __DIR__ . '/../../includes/auth.php';
admin_only();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') { http_response_code(405); exit; }
if (!verify_csrf_token($_POST['csrf_token'] ?? '')) { echo json_encode(['success'=>false,'message'=>'CSRF invalid']); exit; }

$api_key = trim($_POST['api_key'] ?? '');
$env = ($_POST['environment'] === 'sandbox') ? 'sandbox' : 'production';
$base = ($env === 'sandbox') ? 'https://dev.toyyibpay.com/' : 'https://toyyibpay.com/';

if (!$api_key) { echo json_encode(['success'=>false,'message'=>'API Key kosong']); exit; }

$ch = curl_init($base . "index.php/api/createBill");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
  'userSecretKey' => $api_key,
  'categoryCode' => 'test',
  'billName' => 'Ping Test',
  'billDescription' => 'Ujian sambungan API',
  'billPriceSetting' => 1,
  'billAmount' => 1,
  'billReturnUrl' => 'https://example.com'
]));
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$error = curl_error($ch);
curl_close($ch);

if ($error) {
  echo json_encode(['success'=>false,'message'=>'Ralat CURL: '.$error]);
} else {
  echo json_encode(['success'=>true,'message'=>"Sambungan ke $env berjaya! ✅"]);
}
