<?php
require_once __DIR__ . '/../../config/db.php';
require_once __DIR__ . '/../../config/csrf.php';
require_once __DIR__ . '/../../includes/auth.php';
admin_only();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') { http_response_code(405); exit; }
if (!verify_csrf_token($_POST['csrf_token'] ?? '')) { http_response_code(403); exit('CSRF invalid'); }

$api_key = trim($_POST['api_key'] ?? '');
$category_code = trim($_POST['category_code'] ?? '');
$environment = ($_POST['environment'] === 'sandbox') ? 'sandbox' : 'production';

if (!$api_key || !$category_code) {
    header('Location: index.php?error=1');
    exit;
}

$stmt = $pdo->prepare("
    INSERT INTO payment_settings (gateway_name, api_key, category_code, environment)
    VALUES ('toyyibpay', :api_key, :category_code, :env)
    ON DUPLICATE KEY UPDATE api_key=VALUES(api_key), category_code=VALUES(category_code), environment=VALUES(environment)
");
$stmt->execute([
  ':api_key' => $api_key,
  ':category_code' => $category_code,
  ':env' => $environment
]);

header('Location: index.php?saved=1');
exit;
