<?php include '../layout.php'; ?>

<h2 class="text-2xl font-semibold mb-4">💳 Tetapan ToyyibPay</h2>
<p class="text-gray-600 mb-4">Urus kunci API, kategori, dan mod sandbox.</p>

<?php
// sediakan form seperti versi sebelum ini...
require_once '../../config/db.php';
require_once '../../config/csrf.php';

$token = generate_csrf_token();
$stmt = $pdo->prepare("SELECT * FROM payment_settings WHERE gateway_name='toyyibpay' LIMIT 1");
$stmt->execute();
$set = $stmt->fetch();
?>

<form action="save_settings.php" method="post" class="bg-white p-5 rounded shadow max-w-lg">
  <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($token) ?>">
  <label class="block mb-2">API Key</label>
  <input type="text" name="api_key" class="w-full border rounded px-3 py-2 mb-4"
         value="<?= htmlspecialchars($set['api_key'] ?? '') ?>" required>
  <label class="block mb-2">Category Code</label>
  <input type="text" name="category_code" class="w-full border rounded px-3 py-2 mb-4"
         value="<?= htmlspecialchars($set['category_code'] ?? '') ?>" required>
  <label class="block mb-2">Environment</label>
  <select name="environment" class="w-full border rounded px-3 py-2 mb-4">
    <option value="production" <?= ($set['environment'] ?? '') === 'production' ? 'selected' : '' ?>>Production</option>
    <option value="sandbox" <?= ($set['environment'] ?? '') === 'sandbox' ? 'selected' : '' ?>>Sandbox</option>
  </select>
  <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded">Simpan</button>
</form>

<?php include '../layout_bottom.php'; ?>
