<?php
session_start();
require_once __DIR__ . '/../../config/db.php';

date_default_timezone_set('Asia/Kuala_Lumpur');
$logFile = __DIR__ . '/../../logs/toyyib_debug.log';

// Handle log reset
if (isset($_GET['clear']) && $_GET['clear'] === '1') {
    if (file_exists($logFile)) file_put_contents($logFile, '');
    header('Location: debug.php?cleared=1');
    exit;
}

// Baca log file
$logs = file_exists($logFile) ? file_get_contents($logFile) : 'Tiada log direkodkan.';
?>
<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <title>Log Callback ToyyibPay</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
</head>
<body class="bg-gray-100 p-6">
    <div class="max-w-5xl mx-auto bg-white rounded-2xl shadow-lg p-6">
        <div class="flex items-center justify-between mb-4">
            <h1 class="text-2xl font-bold text-green-700">📡 Log Callback ToyyibPay</h1>
            <div class="flex space-x-3">
                <button onclick="window.location.reload()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg">Refresh</button>
                <a href="?clear=1" class="bg-red-600 hover:bg-red-700 text-white px-4 py-2 rounded-lg">Padam Log</a>
            </div>
        </div>

        <div class="bg-gray-900 text-green-300 font-mono text-sm rounded-lg p-4 overflow-y-auto" style="max-height: 70vh;">
            <pre><?= htmlspecialchars($logs) ?></pre>
        </div>

        <div class="text-gray-500 text-xs mt-4 text-center">
            Log disimpan dalam <code>logs/toyyib_debug.log</code> — auto-refresh setiap 15 saat.
        </div>
    </div>

    <script>
        setTimeout(() => window.location.reload(), 15000); // auto refresh setiap 15s
        <?php if (isset($_GET['cleared'])): ?>
        const notyf = new Notyf({ duration: 2500, position: { x: 'center', y: 'top' } });
        notyf.success('Log berjaya dipadam.');
        <?php endif; ?>
    </script>
</body>
</html>
