<?php
require_once __DIR__ . '/../../config/db.php';
require_once __DIR__ . '/../../includes/auth.php';
admin_only();

if (session_status() === PHP_SESSION_NONE) session_start();

// Handle kemaskini status (POST)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['order_id'])) {
  $order_id = $_POST['order_id'];
  $status = $_POST['status'];
  $stmt = $pdo->prepare("UPDATE sales SET payment_status = :status WHERE order_id = :order_id");
  $stmt->execute([':status' => $status, ':order_id' => $order_id]);
  echo json_encode(['success' => true]);
  exit;
}

// Ambil semua rekod
$sales = $pdo->query("SELECT * FROM sales ORDER BY id DESC LIMIT 100")->fetchAll();
$admin_name = $_SESSION['admin_username'] ?? 'Admin';
?>
<!DOCTYPE html>
<html lang="ms">
<head>
  <meta charset="utf-8">
  <title>Rekod Jualan - Admin Panel</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
  <link href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css" rel="stylesheet">
</head>
<body class="flex bg-gray-100 min-h-screen">

<!-- Sidebar -->
<?php include '../layout.php'; ?>

<!-- Main -->
<main class="flex-1">
  <header class="bg-white shadow px-6 py-4 flex justify-between items-center">
    <h1 class="text-xl font-semibold">📊 Rekod Jualan</h1>
    <div class="text-gray-700">👤 <?= htmlspecialchars($admin_name) ?></div>
  </header>

  <section class="p-6">
    <div class="overflow-x-auto bg-white rounded shadow">
      <table class="min-w-full text-sm">
        <thead class="bg-gray-100">
          <tr>
            <th class="p-2 text-left">Order ID</th>
            <th class="p-2 text-left">Nama</th>
            <th class="p-2 text-left">Telefon</th>
            <th class="p-2 text-right">Jumlah (RM)</th>
            <th class="p-2 text-left">Status</th>
            <th class="p-2 text-left">Tarikh Bayar</th>
            <th class="p-2 text-center">Tindakan</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($sales as $s): ?>
          <tr class="border-b hover:bg-gray-50">
            <td class="p-2"><?= htmlspecialchars($s['order_id']) ?></td>
            <td class="p-2"><?= htmlspecialchars($s['buyer_name']) ?></td>
            <td class="p-2"><?= htmlspecialchars($s['buyer_phone']) ?></td>
            <td class="p-2 text-right"><?= number_format($s['amount'], 2) ?></td>
            <td class="p-2">
              <select class="border rounded px-2 py-1 status-select" data-id="<?= $s['order_id'] ?>">
                <option value="PENDING" <?= $s['payment_status']=='PENDING'?'selected':'' ?>>PENDING</option>
                <option value="PAID" <?= $s['payment_status']=='PAID'?'selected':'' ?>>PAID</option>
                <option value="FAILED" <?= $s['payment_status']=='FAILED'?'selected':'' ?>>FAILED</option>
              </select>
            </td>
            <td class="p-2"><?= $s['payment_date'] ?></td>
            <td class="p-2 text-center">
              <button class="save-btn bg-green-600 hover:bg-green-700 text-white px-3 py-1 rounded" data-id="<?= $s['order_id'] ?>">Simpan</button>
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </section>
</main>

<script>
const notyf = new Notyf();
document.querySelectorAll('.save-btn').forEach(btn => {
  btn.addEventListener('click', async () => {
    const id = btn.dataset.id;
    const status = btn.closest('tr').querySelector('.status-select').value;
    const res = await fetch('', {
      method: 'POST',
      headers: {'Content-Type': 'application/x-www-form-urlencoded'},
      body: new URLSearchParams({order_id: id, status})
    });
    const data = await res.json();
    if (data.success) {
      notyf.success('Status berjaya dikemaskini ✅');
    } else {
      notyf.error('Ralat semasa kemaskini ❌');
    }
  });
});
</script>
</body>
</html>
<?php include '../layout_bottom.php'; ?>
