<?php
require_once __DIR__ . '/../includes/auth.php';
admin_only();

if (session_status() === PHP_SESSION_NONE) session_start();
$admin_name = $_SESSION['admin_username'] ?? 'Admin';

?>
<!DOCTYPE html>
<html lang="ms">
<head>
  <meta charset="utf-8">
  <title>Admin Panel - PASTI Kuala Nerus</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
  <link href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
</head>
<body class="flex bg-gray-100 min-h-screen">

  <!-- Sidebar -->
  <aside class="w-64 bg-blue-800 text-white flex flex-col">
    <div class="text-center font-bold text-lg py-4 border-b border-blue-700">
      🌐 Admin Panel
    </div>

    <nav class="flex-1 p-4 space-y-1 text-sm">
      <a href="/pasti/admin/index.php" class="block px-3 py-2 rounded hover:bg-blue-700 transition">🏠 Dashboard</a>

      <div class="mt-4 text-xs uppercase tracking-wider text-blue-300 font-semibold">Tetapan Sistem</div>
      <a href="/pasti/admin/toyyibpay/index.php" class="block px-3 py-2 rounded hover:bg-blue-700">💳 Tetapan ToyyibPay</a>
      <a href="/pasti/admin/whatsapp/index.php" class="block px-3 py-2 rounded hover:bg-blue-700">💬 WhatsApp (Wablas)</a>

      <div class="mt-4 text-xs uppercase tracking-wider text-blue-300 font-semibold">Pengurusan</div>
      <a href="/pasti/admin/sales/index.php" class="block px-3 py-2 rounded hover:bg-blue-700">📊 Rekod Jualan</a>
      <a href="/pasti/admin/reports/index.php" class="block px-3 py-2 rounded hover:bg-blue-700">📈 Laporan (Akan Datang)</a>

      <div class="mt-4 text-xs uppercase tracking-wider text-blue-300 font-semibold">Alat Debug</div>
      <a href="/pasti/admin/toyyibpay/debug.php" class="block px-3 py-2 rounded hover:bg-blue-700">🧩 Debug ToyyibPay</a>
    </nav>

    <div class="p-4 border-t border-blue-700">
      <a href="/pasti/auth/logout.php" class="block text-center bg-red-500 hover:bg-red-600 px-3 py-2 rounded font-medium transition">
        🚪 Logout
      </a>
    </div>
  </aside>

  <!-- Main Content -->
  <main class="flex-1">
    <header class="bg-white shadow px-6 py-4 flex justify-between items-center">
      <h1 class="text-xl font-semibold text-gray-800">Panel Kawalan</h1>
      <div class="text-gray-600 text-sm">👤 <?= htmlspecialchars($admin_name) ?></div>
    </header>

    <section class="p-6">
