<?php
require_once __DIR__ . '/../config/db.php';
require_once __DIR__ . '/../includes/auth.php';
admin_only();
if (session_status() === PHP_SESSION_NONE) session_start();
$admin_name = $_SESSION['admin_username'] ?? 'Admin';
?>
<!DOCTYPE html>
<html lang="ms">
<head>
<meta charset="utf-8">
<title>Dashboard Admin - Pasti Kuala Nerus</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css" rel="stylesheet">
</head>
<?php include 'layout.php'; ?>
<body class="flex bg-gray-100 min-h-screen">

<!-- Sidebar -->


<!-- Main -->
<main class="flex-1">
<header class="bg-white shadow px-6 py-4 flex justify-between items-center">
  <h1 class="text-xl font-semibold">Dashboard Jualan</h1>
  <div class="text-gray-700">👤 <?= htmlspecialchars($admin_name) ?></div>
</header>

<section class="p-6">
  <p class="text-gray-500 text-sm mb-4">Tarikh: <?= date('d M Y') ?></p>

  <div class="grid grid-cols-1 md:grid-cols-4 gap-4 my-6">
    <div class="bg-white p-4 rounded shadow">
      <h3 class="text-sm text-gray-500">Jumlah Transaksi</h3>
      <p class="text-2xl font-bold text-blue-600">
        <?= $pdo->query("SELECT COUNT(*) FROM sales")->fetchColumn(); ?>
      </p>
    </div>
    <div class="bg-white p-4 rounded shadow">
      <h3 class="text-sm text-gray-500">Jumlah Jualan (PAID)</h3>
      <p class="text-2xl font-bold text-green-600">
        RM<?= number_format($pdo->query("SELECT SUM(amount) FROM sales WHERE payment_status='PAID'")->fetchColumn() ?? 0,2); ?>
      </p>
    </div>
    <div class="bg-white p-4 rounded shadow">
      <h3 class="text-sm text-gray-500">Transaksi Pending</h3>
      <p class="text-2xl font-bold text-yellow-600">
        <?= $pdo->query("SELECT COUNT(*) FROM sales WHERE payment_status='PENDING'")->fetchColumn(); ?>
      </p>
    </div>
    <div class="bg-white p-4 rounded shadow">
      <h3 class="text-sm text-gray-500">Transaksi Hari Ini</h3>
      <p class="text-2xl font-bold text-indigo-600">
        <?= $pdo->query("SELECT COUNT(*) FROM sales WHERE DATE(created_at)=CURDATE()")->fetchColumn(); ?>
      </p>
    </div>
  </div>

  <div class="bg-white p-4 rounded shadow mb-6">
    <h2 class="text-lg font-semibold mb-3">📈 Carta Jualan Harian</h2>
    <canvas id="salesChart" height="100"></canvas>
  </div>

  <h2 class="text-lg font-semibold mb-3">🧾 Transaksi Terkini</h2>
  <div class="overflow-x-auto bg-white rounded shadow">
    <table class="min-w-full text-sm">
      <thead class="bg-gray-100">
        <tr>
          <th class="p-2 text-left">Order ID</th>
          <th class="p-2 text-left">Nama</th>
          <th class="p-2 text-right">Jumlah (RM)</th>
          <th class="p-2 text-left">Status</th>
          <th class="p-2 text-left">Tarikh Bayar</th>
        </tr>
      </thead>
      <tbody>
      <?php
      $rows = $pdo->query("SELECT * FROM sales ORDER BY id DESC LIMIT 5")->fetchAll();
      foreach($rows as $r):
      ?>
        <tr class="border-b">
          <td class="p-2"><?= htmlspecialchars($r['order_id']) ?></td>
          <td class="p-2"><?= htmlspecialchars($r['buyer_name']) ?></td>
          <td class="p-2 text-right">RM<?= number_format($r['amount'],2) ?></td>
          <td class="p-2">
            <?php if($r['payment_status']=='PAID'): ?>
              <span class="text-green-600 font-semibold">PAID</span>
            <?php elseif($r['payment_status']=='PENDING'): ?>
              <span class="text-yellow-600 font-semibold">PENDING</span>
            <?php else: ?>
              <span class="text-red-600 font-semibold">FAILED</span>
            <?php endif; ?>
          </td>
          <td class="p-2"><?= $r['payment_date'] ?></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>

  <footer class="mt-8 text-center text-gray-500 text-sm">
    Sistem Integrasi ToyyibPay v3 — Dibangunkan oleh Boss <?= htmlspecialchars($admin_name) ?>
  </footer>
</section>

<script>
fetch('/pasti/admin/sales_data.php')
  .then(res => res.json())
  .then(data => {
    new Chart(document.getElementById('salesChart'), {
      type: 'line',
      data: {
        labels: data.labels,
        datasets: [{
          label: 'Jualan Harian (RM)',
          data: data.values,
          fill: false,
          borderColor: 'rgb(37, 99, 235)',
          tension: 0.3
        }]
      },
      options: { scales: { y: { beginAtZero: true } } }
    });
  });
</script>

</body>
</html>
<?php include 'layout_bottom.php'; ?>