# Secure ToyyibPay Integration (Sandbox + Production toggle)
Short: PHP (Composer-ready) package for ToyyibPay integration with:
- PDO, prepared statements
- CSRF protection
- Sandbox/Production toggle in admin panel
- Tailwind + Notyf UI (CDN)
- Sales recording & admin listing
- No WhatsApp integration (per request)

## Quick setup
1. Extract to your web root.
2. Import SQL: `sql/schema.sql`
3. Update `config/db.php` with DB credentials.
4. Ensure `BASE_URL` in `config/app.php` is `https://kualanerus.net/pasti`.
5. Point ToyyibPay return & callback URLs to:
   - `https://kualanerus.net/pasti/payment/callback.php`
6. Use admin panel: `/admin/toyyibpay/index.php` to set API key, category code and toggle sandbox.
7. Secure the `admin` folder (use HTTPS and proper authentication).

## Notes
- ENV default is `sandbox` in config/app.php. Switch to 'production' when ready.
- For local testing, use ngrok and set public URL as `BASE_URL`.
